
%%Parametros iniciales%%

r0=[1 0]; % El planeta est inicialmente a una U.A. de la estrella
v0=[0 25];  % Su velocidad inicial son 25 km/s
s0 = [r0 v0];   % Vector con las condiciones iniciales
tspan = [0 1];   % Una rbita del planeta son aproximadamente 0.35 aos
N = 2;  % El cuerpo central tiene dos masas solares.
xs=0;   % Posicin X de la estrella
ys=0;   % Posicin Y de la estrella
fun = @(t,s) Problema2C(t,s,N);
% Creo un vector de estructuras con los diferentes valores
% de los parmetros que controlan la precisin.
OrbitaCompleta = @(x,y) CoordenadaY(x,y);
options(1) = odeset('RelTol',1e-3,'AbsTol',1e-3,'Events',OrbitaCompleta);
options(2) = odeset('RelTol',1e-6,'AbsTol',1e-6,'Events',OrbitaCompleta);
options(3) = odeset('RelTol',1e-9,'AbsTol',1e-9,'Events',OrbitaCompleta);
tabla45 = zeros(4,3);   % Aqu guardaremos los resultados para ode45
tabla113 = zeros(4,3);  % Aqu guardaremos los resultados para ode113

%%Resolucion del problema para distintas tolerancias%%

for K=1:1:3
% Solucin usando ODE45
    sol45=ode45(fun,tspan,s0,options(K));
    t45=sol45.x;
    x45=sol45.y(1,:);
    y45=sol45.y(2,:);
    vx45=sol45.y(3,:);
    vy45=sol45.y(4,:);
% Integrales de movimiento usando la solucin de ODE45
    r = [x45 ; y45];
    v = [vx45 ; vy45];
    [E45 L45]=IntegralesProblema2C(r,v,N);
% Solucin usando ODE113
    sol113=ode113(fun,tspan,s0,options(K));
    t113=sol113.x;
    x113=sol113.y(1,:);
    y113=sol113.y(2,:);
    vx113=sol113.y(3,:);
    vy113=sol113.y(4,:);
% Integrales de movimiento usando la solucin de ODE113
    r = [x113 ; y113];
    v = [vx113 ; vy113];
    [E113 L113]=IntegralesProblema2C(r,v,N);
% Calculamos los valores que hemos de tabular.
    tabla45(1,K) = sol45.stats.nfevals;                 % No. de evaluaciones de las derivadas
    tabla45(2,K) = abs(max(E45)-min(E45))/abs(E45(1));  % Variacin relativa de la energa
    tabla45(3,K) = abs(max(L45)-min(L45))/abs(L45(1));  % Variacin relativa del momento angular
    tabla45(4,K) = sol45.x(length(sol45.x));            % Perodo orbital
    tabla113(1,K) = sol113.stats.nfevals;
    tabla113(2,K) = abs(max(E113)-min(E113))/abs(E113(1));
    tabla113(3,K) = abs(max(L113)-min(L113))/abs(L113(1));
    tabla113(4,K) = sol113.x(length(sol113.x));
% Representamos las soluciones
    figure(3*K-2)
    hold on
    plot(xs,ys,'ok','MarkerFaceColor','k')
    plot(x45,y45,'-ob',x113,y113,'-*r');
    xlabel('x (U.A.)');
    ylabel('y (U.A.)');
    legend('Estrella','ode45','ode113','Location','SouthWest');
    titulo = ['rbita del planeta. RelTol , AbsTol = ' num2str(options(K).RelTol)];
    title(titulo);
    hold off
    figure(3*K-1);
    plot(t45,E45,'-ob',t113,E113,'-*r');
    xlabel('t (aos)');
    ylabel('E/m (km^2/s^2)');
    legend('ode45','ode113','Location','SouthWest');
    titulo = ['Energa del planeta. RelTol , AbsTol = ' num2str(options(K).RelTol)];
    title(titulo);
    figure(3*K);
    plot(t45,L45,'-ob',t113,L113,'-*r');
    xlabel('t (aos)');
    ylabel('L/m (U.A. km/s)');
    legend('ode45','ode113','Location','SouthWest');
    titulo = ['Momento angular del planeta. RelTol , AbsTol = ' num2str(options(K).RelTol)];
    title(titulo);
end

%%Tabla%%

fprintf('RelTol,AbsTol: \t \t 1e-3 \t \t 1e-6 \t \t 1e-9 \n');
fprintf('Funcin ode45: \n')
fprintf('No. de evaluaciones: \t %d \t \t %d \t \t %d \n',tabla45(1,1),tabla45(1,2),tabla45(1,3));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \t %6.3e \t %6.3e \n',tabla45(2,1),tabla45(2,2),tabla45(2,3));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \t %6.3e \t %6.3e \n',tabla45(3,1),tabla45(3,2),tabla45(3,3));
fprintf('Perodo orbital: \t %f \t %f \t %f \t (aos) \n',tabla45(4,1),tabla45(4,2),tabla45(4,3));
fprintf('Funcin ode113: \n');
fprintf('No. de evaluaciones: \t %d \t \t %d \t \t %d \n',tabla113(1,1),tabla113(1,2),tabla113(1,3));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \t %6.3e \t %6.3e \n',tabla113(2,1),tabla113(2,2),tabla113(2,3));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \t %6.3e \t %6.3e \n',tabla113(3,1),tabla113(3,2),tabla113(3,3));
fprintf('Perodo orbital: \t %f \t %f \t %f \t (aos) \n',tabla113(4,1),tabla113(4,2),tabla113(4,3));

